/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.dialog.IVWWebServiceParamPanel;
import filenet.vw.toolkit.design.property.dialog.VWReceiveWSOperationParameterPanel;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.table.VWSortedComboBoxModel;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class VWReceiveGeneralPanel
extends JPanel
implements FocusListener,
ActionListener,
IVWPropertyChangeListener {
    private static final int MODE_BASIC = 0;
    private static final int MODE_ADVANCED = 1;
    private JComboBox m_partnerLinkCombo = null;
    private JTextField m_operationTextField = null;
    private JRadioButton m_basicRB = null;
    private JRadioButton m_advancedRB = null;
    private VWReceiveWSOperationParameterPanel m_simplePanel = null;
    private VWToolbarBorder m_incomingXMLDataFieldBorder = null;
    private JComboBox m_incomingXMLDataFieldComboBox = null;
    private VWToolbarBorder m_schemaBorder = null;
    private JComboBox m_schemaCombo = null;
    private VWToolbarBorder m_elementBorder = null;
    private JComboBox m_elementCombo = null;
    private JLabel m_advancedSpacerLabel = null;
    private JDialog m_parentDialog = null;
    private Frame m_parentFrame = null;
    private IVWWebServiceParamPanel m_parentWSParamPanel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWReceiveInstruction m_instructionDef = null;
    private String m_oldOperation = null;

    public VWReceiveGeneralPanel(JDialog parentDialog, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_parentDialog = parentDialog;
        this.m_parentWSParamPanel = parentPanel;
        this.m_authPropertyData = authPropertyData;
        this.createControls(nDisplayMode);
    }

    public VWReceiveGeneralPanel(Frame parentFrame, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_parentFrame = parentFrame;
        this.m_parentWSParamPanel = parentPanel;
        this.m_authPropertyData = authPropertyData;
        this.createControls(nDisplayMode);
    }

    public void setInstructionDefinition(VWReceiveInstruction instructionDef) {
        if (instructionDef != null) {
            this.m_instructionDef = instructionDef;
            this.reinitialize();
        }
    }

    public void focusGained(FocusEvent event) {
        if (event.getComponent().equals(this.m_operationTextField)) {
            this.m_oldOperation = this.m_operationTextField.getText();
        }
    }

    public void focusLost(FocusEvent event) {
        try {
            if (event.getComponent().equals(this.m_operationTextField)) {
                String newOperation = this.m_operationTextField.getText();
                if (VWStringUtils.compareIgnoreCase(newOperation, this.m_oldOperation) == 0) {
                    return;
                }
                this.m_oldOperation = null;
                if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                    this.m_instructionDef.setOperationName(newOperation);
                    this.m_authPropertyData.setDirty();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src.equals(this.m_partnerLinkCombo)) {
            this.performPartnerLinkAction();
        } else if (src.equals(this.m_advancedRB)) {
            this.performAdvancedAction(true);
        } else if (src.equals(this.m_basicRB)) {
            this.performBasicAction(true);
        } else if (src.equals(this.m_incomingXMLDataFieldComboBox)) {
            this.performIncomingXMLDataFieldAction();
        } else if (src.equals(this.m_schemaCombo)) {
            this.performSchemaAction();
        } else if (src.equals(this.m_elementCombo)) {
            this.performElementAction();
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 526: 
            case 527: 
            case 528: 
            case 529: {
                this.initPartnerLinkComboBox();
                break;
            }
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 563: 
            case 564: 
            case 565: 
            case 566: {
                this.initXMLDataFieldComboBox();
                break;
            }
            case 547: 
            case 548: 
            case 549: {
                this.initSchemaComboBox();
            }
        }
    }

    private void initPartnerLinkComboBox() {
        this.m_partnerLinkCombo.removeActionListener(this);
        this.m_partnerLinkCombo.removeAllItems();
        this.m_partnerLinkCombo.addItem(VWResource.s_noneItemStr);
        if (this.m_instructionDef != null && this.m_authPropertyData != null) {
            boolean bFound = false;
            String partnerLinkName = this.m_instructionDef.getPartnerLinkName();
            try {
                VWPartnerLinkDefinition[] partnerLinks = this.m_authPropertyData.getPartnerLinks();
                if (partnerLinks != null && partnerLinks.length > 0) {
                    Vector<String> nameVector = new Vector<String>();
                    for (int i = 0; i < partnerLinks.length; ++i) {
                        if (partnerLinks[i].getMyPortType() == null) continue;
                        nameVector.addElement(partnerLinks[i].getName());
                    }
                    Object[] partnerLinkNames = null;
                    if (nameVector.size() > 0) {
                        partnerLinkNames = new String[nameVector.size()];
                        nameVector.copyInto(partnerLinkNames);
                        nameVector.removeAllElements();
                        nameVector = null;
                    }
                    if (partnerLinkNames != null) {
                        VWQubbleSort.sort(partnerLinkNames);
                        for (int i = 0; i < partnerLinkNames.length; ++i) {
                            this.m_partnerLinkCombo.addItem(partnerLinkNames[i]);
                            if (bFound || partnerLinkName == null) continue;
                            bFound = partnerLinkName.compareTo((String)partnerLinkNames[i]) == 0;
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            if (partnerLinkName != null && partnerLinkName.length() > 0) {
                if (!bFound) {
                    this.m_partnerLinkCombo.addItem(partnerLinkName);
                }
                this.m_partnerLinkCombo.setSelectedItem(partnerLinkName);
            } else {
                this.m_partnerLinkCombo.setSelectedIndex(0);
            }
        }
        this.m_partnerLinkCombo.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSchemaComboBox() {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        cbModel.addElement(VWResource.s_noneItemStr);
        int nSchemaIndex = 0;
        try {
            Object[] schemas;
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (schemas = this.m_authPropertyData.getSchemas()) != null && schemas.length > 0) {
                VWQubbleSort.sort(schemas);
                String schemaName = this.m_instructionDef.getMessageFromSchemaName();
                for (int i = 0; i < schemas.length; ++i) {
                    Object schema = schemas[i];
                    String name = ((VWSchema)schema).getName();
                    if (schemaName != null && VWStringUtils.compare(name, schemaName) == 0) {
                        nSchemaIndex = i + 1;
                    }
                    cbModel.addElement(name);
                }
                if (schemaName != null && nSchemaIndex == 0) {
                    cbModel.addElement(schemaName);
                    nSchemaIndex = cbModel.getSize() - 1;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_schemaCombo.removeActionListener(this);
            this.m_schemaCombo.setModel(cbModel);
            this.m_schemaCombo.setSelectedIndex(nSchemaIndex);
            this.m_schemaCombo.addActionListener(this);
            this.initElementComboBox(true);
            if (this.m_parentWSParamPanel != null) {
                this.m_parentWSParamPanel.reinitializeCorrelationParamList();
                this.m_parentWSParamPanel.switchCSPanelAdvancedMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initElementComboBox(boolean bAddSetting) {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        cbModel.addElement(VWResource.s_noneItemStr);
        int nElementIndex = 0;
        try {
            VWSchema vwSchema;
            String schemaName;
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (schemaName = this.m_instructionDef.getMessageFromSchemaName()) != null && (vwSchema = this.m_authPropertyData.getSchema(schemaName)) != null) {
                VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                String schema = vwSchema.getSchema();
                if (wsUtils != null && schema != null && schema.length() > 0) {
                    String[] elementNames = wsUtils.getElementNamesFromSchema(schema);
                    String elementName = this.m_instructionDef.getMessageFromElementName();
                    if (elementNames != null && elementNames.length > 0) {
                        for (int i = 0; i < elementNames.length; ++i) {
                            if (elementName != null && VWStringUtils.compare(elementNames[i], elementName) == 0) {
                                nElementIndex = i + 1;
                            }
                            cbModel.addElement(elementNames[i]);
                        }
                    }
                    if (bAddSetting && elementName != null && nElementIndex == 0) {
                        cbModel.addElement(elementName);
                        nElementIndex = cbModel.getSize() - 1;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            if (this.m_authPropertyData != null && !bAddSetting) {
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorRetrievingSchemaElements, 1);
            }
        }
        finally {
            this.m_elementCombo.removeActionListener(this);
            this.m_elementCombo.setModel(cbModel);
            this.m_elementCombo.setSelectedIndex(nElementIndex);
            this.m_elementCombo.addActionListener(this);
        }
    }

    protected void reinitialize() {
        try {
            if (this.m_instructionDef != null) {
                this.m_simplePanel.reinitialize(this.m_instructionDef);
                this.initPartnerLinkComboBox();
                this.m_operationTextField.setText(this.m_instructionDef.getOperationName());
                this.initXMLDataFieldComboBox();
                this.initSchemaComboBox();
                try {
                    switch (this.getMode()) {
                        case 0: {
                            this.m_basicRB.removeActionListener(this);
                            this.m_basicRB.setSelected(true);
                            this.m_basicRB.addActionListener(this);
                            this.performBasicAction(false);
                            break;
                        }
                        case 1: {
                            this.m_advancedRB.removeActionListener(this);
                            this.m_advancedRB.setSelected(true);
                            this.m_advancedRB.addActionListener(this);
                            this.performAdvancedAction(false);
                        }
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(int nDisplayMode) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 0, 5);
            if (nDisplayMode == 0) {
                gbCons.insets = new Insets(5, 5, 0, 20);
            }
            VWToolbarBorder partnerLinkBorder = new VWToolbarBorder(VWResource.s_partnerLink);
            JPanel partnerLinkPanel = partnerLinkBorder.getClientPanel();
            partnerLinkPanel.setLayout(new BorderLayout());
            this.m_partnerLinkCombo = new JComboBox();
            this.m_partnerLinkCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_partnerLinkCombo.addActionListener(this);
            partnerLinkPanel.add(this.m_partnerLinkCombo);
            this.add((Component)partnerLinkBorder, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 5, 0, 5);
            if (nDisplayMode == 0) {
                gbCons.gridheight = 0;
                gbCons.insets = new Insets(0, 5, 0, 20);
            }
            VWToolbarBorder operationBorder = new VWToolbarBorder(VWResource.s_operation);
            JPanel operationPanel = operationBorder.getClientPanel();
            operationPanel.setLayout(new BorderLayout());
            this.m_operationTextField = new JTextField();
            this.m_operationTextField.addFocusListener(this);
            operationPanel.add(this.m_operationTextField);
            this.add((Component)operationBorder, gbCons);
            ++gbCons.gridy;
            gbCons.gridheight = 1;
            if (nDisplayMode == 0) {
                ++gbCons.gridx;
                gbCons.gridy = 0;
            }
            VWToolbarBorder messageTypeBorder = new VWToolbarBorder(VWResource.s_messageType);
            JPanel msgTypePanel = messageTypeBorder.getClientPanel();
            msgTypePanel.setLayout(new GridLayout(1, 3));
            this.m_basicRB = new JRadioButton(VWResource.s_parametersStr);
            this.m_basicRB.setSelected(true);
            this.m_basicRB.addActionListener(this);
            msgTypePanel.add(this.m_basicRB);
            this.m_advancedRB = new JRadioButton(VWResource.s_xml);
            this.m_advancedRB.setSelected(false);
            this.m_advancedRB.addActionListener(this);
            msgTypePanel.add(this.m_advancedRB);
            ButtonGroup msgTypeGrp = new ButtonGroup();
            msgTypeGrp.add(this.m_basicRB);
            msgTypeGrp.add(this.m_advancedRB);
            this.add((Component)messageTypeBorder, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_simplePanel = this.m_parentDialog != null ? new VWReceiveWSOperationParameterPanel(this.m_parentDialog, this.m_parentWSParamPanel, this.m_authPropertyData) : new VWReceiveWSOperationParameterPanel(this.m_parentFrame, this.m_parentWSParamPanel, this.m_authPropertyData);
            this.add((Component)this.m_simplePanel, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weighty = 0.0;
            this.m_incomingXMLDataFieldBorder = new VWToolbarBorder(VWResource.s_incomingXMLDataField);
            JPanel incomingXMLPanel = this.m_incomingXMLDataFieldBorder.getClientPanel();
            incomingXMLPanel.setLayout(new BorderLayout());
            this.m_incomingXMLDataFieldComboBox = new JComboBox(new VWSortedComboBoxModel());
            this.m_incomingXMLDataFieldComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_incomingXMLDataFieldComboBox.setEditable(true);
            this.m_incomingXMLDataFieldComboBox.addActionListener(this);
            this.initXMLDataFieldComboBox();
            incomingXMLPanel.add(this.m_incomingXMLDataFieldComboBox);
            this.add((Component)this.m_incomingXMLDataFieldBorder, gbCons);
            ++gbCons.gridy;
            this.m_schemaBorder = new VWToolbarBorder(VWResource.s_schema);
            JPanel schemaPanel = this.m_schemaBorder.getClientPanel();
            schemaPanel.setLayout(new BorderLayout());
            this.m_schemaCombo = new JComboBox();
            this.m_schemaCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_schemaCombo.addActionListener(this);
            schemaPanel.add(this.m_schemaCombo);
            this.add((Component)this.m_schemaBorder, gbCons);
            ++gbCons.gridy;
            this.m_elementBorder = new VWToolbarBorder(VWResource.s_element);
            JPanel elementPanel = this.m_elementBorder.getClientPanel();
            elementPanel.setLayout(new BorderLayout());
            this.m_elementCombo = new JComboBox();
            this.m_elementCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_elementCombo.addActionListener(this);
            this.m_elementCombo.setEditable(true);
            elementPanel.add(this.m_elementCombo);
            this.add((Component)this.m_elementBorder, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 0.9;
            this.m_advancedSpacerLabel = new JLabel();
            this.add((Component)this.m_advancedSpacerLabel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    private void initXMLDataFieldComboBox() {
        String incomingXMLDataField = null;
        if (this.m_instructionDef != null) {
            incomingXMLDataField = this.m_instructionDef.getMessageExpr();
        }
        this.m_incomingXMLDataFieldComboBox.removeActionListener(this);
        try {
            VWSortedComboBoxModel model = (VWSortedComboBoxModel)this.m_incomingXMLDataFieldComboBox.getModel();
            if (model != null) {
                model.removeAllElements();
                model.addElement(VWResource.s_noneItemStr);
                boolean bFound = false;
                VWFieldDefinition[] fieldDefs = this.m_authPropertyData.getFields();
                if (fieldDefs != null) {
                    for (int i = 0; i < fieldDefs.length; ++i) {
                        VWFieldDefinition fieldDef = fieldDefs[i];
                        int fieldType = fieldDef.getFieldType();
                        String fieldName = fieldDef.getName();
                        if (fieldType == 128 || fieldType == 2) {
                            model.addElement(fieldName);
                        }
                        if (bFound || incomingXMLDataField == null || VWStringUtils.compare(fieldName, incomingXMLDataField) != 0) continue;
                        bFound = true;
                    }
                }
                if (!bFound && incomingXMLDataField != null && incomingXMLDataField.length() > 0) {
                    model.addElement(incomingXMLDataField);
                }
                model.sort(VWResource.s_noneItemStr);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (incomingXMLDataField != null && incomingXMLDataField.length() > 0) {
            this.m_incomingXMLDataFieldComboBox.setSelectedItem(incomingXMLDataField);
        } else {
            this.m_incomingXMLDataFieldComboBox.setSelectedItem(VWResource.s_noneItemStr);
        }
        this.m_incomingXMLDataFieldComboBox.addActionListener(this);
    }

    private void performPartnerLinkAction() {
        try {
            String partnerLink = (String)this.m_partnerLinkCombo.getSelectedItem();
            if (partnerLink.compareTo(VWResource.s_noneItemStr) == 0) {
                partnerLink = "";
            }
            if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                this.m_instructionDef.setPartnerLinkName(partnerLink);
                this.m_instructionDef.setOperationName(null);
                this.m_operationTextField.setText(null);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAdvancedAction(boolean resetValue) {
        try {
            this.m_simplePanel.setVisible(false);
            this.m_incomingXMLDataFieldBorder.setVisible(true);
            this.m_schemaBorder.setVisible(true);
            this.m_elementBorder.setVisible(true);
            this.m_advancedSpacerLabel.setVisible(true);
            if (resetValue) {
                this.setMode(1, resetValue);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performBasicAction(boolean resetValue) {
        try {
            this.m_simplePanel.setVisible(true);
            this.m_incomingXMLDataFieldBorder.setVisible(false);
            this.m_schemaBorder.setVisible(false);
            this.m_elementBorder.setVisible(false);
            this.m_advancedSpacerLabel.setVisible(false);
            if (resetValue) {
                this.setMode(0, resetValue);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int getMode() {
        int nMode = 0;
        try {
            if (this.m_instructionDef != null) {
                String incomingMsg = this.m_instructionDef.getMessageExpr();
                nMode = incomingMsg == null ? 0 : 1;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nMode;
    }

    private void setMode(int mode, boolean bInitValue) {
        try {
            switch (mode) {
                case 0: {
                    if (this.m_instructionDef != null) {
                        this.m_instructionDef.setMessageExpr(null);
                        this.m_instructionDef.setCorrelationSetName(null);
                        this.m_instructionDef.setCorrelationParameterSequenceNumber(-1);
                        this.m_instructionDef.setCorrelationValueExpression(null);
                        this.m_instructionDef.setMessageFromSchemaName(null);
                        this.m_instructionDef.setMessageFromElementName(null);
                    }
                    this.m_simplePanel.reinitialize(this.m_instructionDef);
                    this.m_parentWSParamPanel.switchCSPanelBasicMode();
                    break;
                }
                case 1: {
                    if (this.m_instructionDef != null) {
                        this.m_instructionDef.deleteAllParameters();
                        if (bInitValue) {
                            this.m_instructionDef.setMessageExpr(null);
                            this.m_instructionDef.setCorrelationSetName(null);
                            this.m_instructionDef.setCorrelationParameterSequenceNumber(-1);
                            this.m_instructionDef.setCorrelationValueExpression(null);
                            this.m_instructionDef.setMessageFromSchemaName(null);
                            this.m_instructionDef.setMessageFromElementName(null);
                        }
                    }
                    this.initXMLDataFieldComboBox();
                    this.initSchemaComboBox();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performIncomingXMLDataFieldAction() {
        try {
            if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                VWFieldDefinition fieldDef;
                String xmlDataField = (String)this.m_incomingXMLDataFieldComboBox.getSelectedItem();
                if (VWStringUtils.compare(xmlDataField, VWResource.s_noneItemStr) == 0) {
                    xmlDataField = null;
                }
                this.m_instructionDef.setMessageExpr(xmlDataField);
                if (xmlDataField != null && (fieldDef = this.m_authPropertyData.getField(xmlDataField)) != null && fieldDef.getValue() != null && fieldDef.getValue() instanceof VWXMLData) {
                    VWXMLData vwXMLData = (VWXMLData)fieldDef.getValue();
                    if (vwXMLData.getSchemaName() != null && this.m_instructionDef.getMessageFromSchemaName() == null) {
                        this.m_instructionDef.setMessageFromSchemaName(vwXMLData.getSchemaName());
                    }
                    if (vwXMLData.getElementName() != null && this.m_instructionDef.getMessageFromElementName() == null) {
                        this.m_instructionDef.setMessageFromElementName(vwXMLData.getElementName());
                    }
                    this.initSchemaComboBox();
                }
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSchemaAction() {
        try {
            String schema;
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (schema = (String)this.m_schemaCombo.getSelectedItem()) != null) {
                if (VWStringUtils.compare(schema, VWResource.s_noneItemStr) == 0) {
                    schema = null;
                }
                this.m_instructionDef.setMessageFromSchemaName(schema);
                this.initElementComboBox(false);
                if (this.m_parentWSParamPanel != null) {
                    this.m_parentWSParamPanel.reinitializeCorrelationParamList();
                }
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performElementAction() {
        try {
            String element;
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (element = (String)this.m_elementCombo.getSelectedItem()) != null) {
                if (VWStringUtils.compare(element, VWResource.s_noneItemStr) == 0) {
                    element = null;
                }
                this.m_instructionDef.setMessageFromElementName(element);
                if (this.m_parentWSParamPanel != null) {
                    this.m_parentWSParamPanel.reinitializeCorrelationParamList();
                }
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

